/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ChestRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lidPart;
    private final ModelPart bottomPart;
    private final ModelPart lockPart;
    private static final String ENTITY_CHEST_FOLDER = "entity/chest/";
    public static final Map<WoodType, Material> WOOD_MATERIALS = new HashMap<WoodType, Material>();
    public static final Material WOOD_TIER_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/wood_tier"));
    public static final Material IRON_TIER_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/iron_tier"));
    public static final Material GOLD_TIER_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/gold_tier"));
    public static final Material DIAMOND_TIER_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/diamond_tier"));
    public static final Material NETHERITE_TIER_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/netherite_tier"));
    public static final Material TINTABLE_MAIN_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/tintable_main"));
    public static final Material TINTABLE_ACCENT_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/tintable_accent"));
    public static final Material PACKED_MATERIAL = new Material(Sheets.f_110740_, SophisticatedStorage.getRL("entity/chest/packed"));

    public ChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ClientEventHandler.CHEST_LAYER);
        this.bottomPart = modelpart.m_171324_(BOTTOM);
        this.lidPart = modelpart.m_171324_(LID);
        this.lockPart = modelpart.m_171324_(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer(boolean addLock) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        if (addLock) {
            partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(ChestBlockEntity chestEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedlight, int packedOverlay) {
        VertexConsumer vertexconsumer;
        BlockState blockstate = chestEntity.m_58900_();
        poseStack.m_85836_();
        float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.FACING)).m_122435_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        float finalLidAngle = lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        boolean hasMainColor = chestEntity.getStorageWrapper().hasMainColor();
        boolean hasAccentColor = chestEntity.getStorageWrapper().hasAccentColor();
        Optional<WoodType> woodType = chestEntity.getWoodType();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            vertexconsumer = WOOD_MATERIALS.get(woodType.orElse(WoodType.f_61833_)).m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLid(poseStack, vertexconsumer, finalLidAngle, packedlight, packedOverlay);
        }
        if (hasMainColor) {
            vertexconsumer = TINTABLE_MAIN_MATERIAL.m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLidWithTint(poseStack, vertexconsumer, lidAngle, packedlight, packedOverlay, chestEntity.getStorageWrapper().getMainColor());
        }
        if (hasAccentColor) {
            vertexconsumer = TINTABLE_ACCENT_MATERIAL.m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLidWithTint(poseStack, vertexconsumer, lidAngle, packedlight, packedOverlay, chestEntity.getStorageWrapper().getAccentColor());
        }
        Material tierMaterial = this.getTierMaterial(blockstate.m_60734_());
        VertexConsumer vertexconsumer2 = tierMaterial.m_119194_(bufferSource, RenderType::m_110452_);
        this.renderBottomAndLid(poseStack, vertexconsumer2, lidAngle, packedlight, packedOverlay);
        this.renderLock(poseStack, vertexconsumer2, lidAngle, packedlight, packedOverlay);
        poseStack.m_85849_();
        if (chestEntity.isPacked()) {
            VertexConsumer consumer = PACKED_MATERIAL.m_119194_(bufferSource, RenderType::m_110452_);
            poseStack.m_85836_();
            poseStack.m_85837_(-0.005, -0.005, -0.005);
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            this.renderBottomAndLid(poseStack, consumer, finalLidAngle, packedlight, packedOverlay);
            poseStack.m_85849_();
        } else {
            BarrelRenderer.renderDisplayItem(chestEntity, poseStack, bufferSource, packedlight, packedOverlay, 0.4375, 0.51875);
        }
    }

    private void renderBottomAndLid(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        this.bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private void renderBottomAndLidWithTint(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay, int tint) {
        float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(tint & 0xFF) / 255.0f;
        this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lidPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
        this.bottomPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }

    private void renderLock(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lockPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private Material getTierMaterial(Block block) {
        if (block == ModBlocks.IRON_CHEST.get()) {
            return IRON_TIER_MATERIAL;
        }
        if (block == ModBlocks.GOLD_CHEST.get()) {
            return GOLD_TIER_MATERIAL;
        }
        if (block == ModBlocks.DIAMOND_CHEST.get()) {
            return DIAMOND_TIER_MATERIAL;
        }
        if (block == ModBlocks.NETHERITE_CHEST.get()) {
            return NETHERITE_TIER_MATERIAL;
        }
        return WOOD_TIER_MATERIAL;
    }

    static {
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach(woodType -> WOOD_MATERIALS.put((WoodType)woodType, new Material(Sheets.f_110740_, SophisticatedStorage.getRL(ENTITY_CHEST_FOLDER + woodType.m_61846_()))));
    }
}

